﻿/*	VERS:	1.1
	1.1		Add:	"self_tree" parameter to specify a tree component

	WHAT:
	This scrolls a tree to the specified node, and selects it.
	
	NOTE: 
	A sub-node can only be found if its parent node is open.
	
	USAGE: 
	// find this node
	var targNode = findNode( "z2" );
	// reveal the specified node  (open its parent nodes)
	openParentNodes( targNode );
	// scroll to the node
	scrollToNode( targNode );
*/

// This function does not use  "function funcName("  because "this" would be undefined if it did.
var scrollToNode_selfTree = this;
var scrollToNode = function(targetNode, self_tree )
{
	// try to acquire a tree to work with
	if( self_tree instanceof mx.controls.Tree === false )					var self_tree = scrollToNode_selfTree;
	if( self_tree instanceof mx.controls.Tree === false )					var self_tree = _this;
	if( self_tree instanceof mx.controls.Tree === false )					return;
	if(self_tree.__dataProvider.length == 0)		// if:  the list is empty
		return;
	
	var currentIndex = self_tree.getSelectedIndex();
	if (currentIndex == undefined)		// if:  nothing is selected
		currentIndex = 0;								// select the 1st item
	var selectionOffset = 0;
	
	for(var checkIndex=0; checkIndex<self_tree.length; checkIndex++)
	{
		var checkNode = self_tree.getNodeDisplayedAt(checkIndex);
		if(checkNode == targetNode){
			selectionOffset = checkIndex -currentIndex;
			if( selectionOffset < 0)		selectionOffset = 0;		// avoid trying to select -1
			break;
		}// if:  node is found
	}// for:  each item in this list
	
	if(selectionOffset !== 0)		self_tree.moveSelBy(selectionOffset);
} // End of the function